/*
 * Decompiled with CFR 0.152.
 */
package org.secverse.SecVerseDupeUtils.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EventsKeys {
    private final Plugin plugin;
    private final List<BlacklistEntry> cachedBlacklist;

    public EventsKeys(Plugin plugin) {
        this.plugin = plugin;
        this.cachedBlacklist = this.loadBlacklist();
    }

    private List<BlacklistEntry> loadBlacklist() {
        List<Map<?, ?>> blacklists = this.plugin.getConfig().getMapList("ItemBlacklist");
        ArrayList<BlacklistEntry> entries = new ArrayList<BlacklistEntry>();
        for (Map<?, ?> entry : blacklists) {
            String namespace = (String)entry.get("Namespace");
            String key = (String)entry.get("Key");
            List names = (List)entry.get("Names");
            if (namespace == null || key == null || names == null) continue;
            NamespacedKey nk = new NamespacedKey(namespace, key);
            entries.add(new BlacklistEntry(nk, names));
        }
        return entries;
    }

    public boolean isBlockedItem(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (BlacklistEntry entry : this.cachedBlacklist) {
            String type;
            if (!container.has(entry.key, PersistentDataType.STRING) || (type = container.get(entry.key, PersistentDataType.STRING)) == null || !entry.names.stream().anyMatch(s2 -> s2.equalsIgnoreCase(type))) continue;
            return true;
        }
        return false;
    }

    public void reload() {
        this.cachedBlacklist.clear();
        this.cachedBlacklist.addAll(this.loadBlacklist());
    }

    private static class BlacklistEntry {
        public final NamespacedKey key;
        public final List<String> names;

        public BlacklistEntry(NamespacedKey key, List<String> names) {
            this.key = key;
            this.names = names;
        }
    }
}

