/*
 * Decompiled with CFR 0.152.
 */
package org.secverse.SecVerseDupeUtils.SecVersCom;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class UpdateChecker {
    private static final String ENDPOINT_URL = "https://api.secvers.org/v1/plugin/SecVersDupeUtils";
    private static final String DOWNLOAD_URL = "https://secvers.org/";
    private static final Pattern SIMPLE_JSON_VERSION = Pattern.compile("\"version\"\\s*:\\s*\"([^\"]+)\"");
    private final Plugin plugin;

    public UpdateChecker(Plugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
    }

    public void checkNowAsync() {
        new BukkitRunnable(){

            @Override
            public void run() {
                try {
                    String remoteVersion = UpdateChecker.this.fetchRemoteVersion(UpdateChecker.ENDPOINT_URL);
                    if (remoteVersion == null || remoteVersion.isEmpty()) {
                        UpdateChecker.this.plugin.getLogger().warning("[Update] Could not parse remote version.");
                        return;
                    }
                    String localVersion = UpdateChecker.this.plugin.getDescription().getVersion();
                    if (UpdateChecker.isOutdated(localVersion, remoteVersion)) {
                        UpdateChecker.this.broadcastUpdate(remoteVersion, localVersion);
                    } else {
                        UpdateChecker.this.plugin.getLogger().info("[Update] Plugin is up-to-date. Local " + localVersion + ", Remote " + remoteVersion);
                    }
                }
                catch (Exception ex) {
                    UpdateChecker.this.plugin.getLogger().warning("[Update] Failed to check updates: " + ex.getMessage());
                }
            }
        }.runTaskAsynchronously(this.plugin);
    }

    private String fetchRemoteVersion(String url) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(6000);
        conn.setReadTimeout(6000);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        int code = conn.getResponseCode();
        if (code != 200) {
            throw new IllegalStateException("HTTP " + code);
        }
        try {
            BufferedReader br;
            block12: {
                String string;
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                try {
                    String ln;
                    StringBuilder sb = new StringBuilder();
                    while ((ln = br.readLine()) != null) {
                        sb.append(ln);
                    }
                    String json = sb.toString();
                    Matcher m4 = SIMPLE_JSON_VERSION.matcher(json);
                    if (!m4.find()) break block12;
                    string = m4.group(1).trim();
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                br.close();
                return string;
            }
            String string = null;
            br.close();
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public static boolean isOutdated(String local, String remote) {
        return !UpdateChecker.normalize(local).equals(UpdateChecker.normalize(remote));
    }

    private static String normalize(String v) {
        if (v == null) {
            return "0";
        }
        String core = v.split("[+-]")[0];
        return (core = core.replaceAll("[^0-9.]", "")).isEmpty() ? "0" : core;
    }

    private void broadcastUpdate(String remoteVersion, String localVersion) {
        Server server = Bukkit.getServer();
        String legacy = "\u00a7c\u00a7l[SecVers] New Update available: " + remoteVersion + " (current " + localVersion + "). Download: https://secvers.org/";
        Bukkit.broadcastMessage(legacy);
        server.getConsoleSender().sendMessage(legacy);
    }
}

