/*
 * Decompiled with CFR 0.152.
 */
package org.secverse.SecVerseDupeUtils.SecVersCom;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Telemetry {
    private static final String HWID_FILENAME = "hwid.txt";
    private final Plugin plugin;
    private final File dataFolder;
    private final UUID hwid;
    private final String endpoint;
    private final boolean enabled;
    private static final String ENDPOINT_URL = "https://api.secvers.org/v1/telemetry/SecVersDupeUtils";

    public Telemetry(Plugin plugin) {
        boolean created;
        this.plugin = plugin;
        this.dataFolder = plugin.getDataFolder();
        if (!this.dataFolder.exists() && !(created = this.dataFolder.mkdirs())) {
            plugin.getLogger().warning("Could not create plugin data folder for telemetry persistence.");
        }
        this.enabled = plugin.getConfig().getBoolean("telemetry.enabled", true);
        this.endpoint = plugin.getConfig().getString("telemetry.endpoint", "").trim();
        this.hwid = this.loadOrCreateHwid();
    }

    public UUID getHwid() {
        return this.hwid;
    }

    public String getServerName() {
        String name = Bukkit.getServer().getName();
        if (name == null || name.isEmpty()) {
            return "unknown";
        }
        return name;
    }

    public String buildPayload(Map<String, Object> additional) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("hwid", this.hwid.toString());
        payload.put("serverName", this.getServerName());
        payload.put("pluginName", this.plugin.getDescription().getName());
        payload.put("pluginVersion", this.plugin.getDescription().getVersion());
        payload.put("timestamp", Instant.now().toString());
        if (additional != null) {
            payload.putAll(additional);
        }
        return Telemetry.toJson(payload);
    }

    public void sendTelemetryAsync(Map<String, Object> additional) {
        if (!this.enabled) {
            this.plugin.getLogger().info("Telemetry disabled in config; skipping send.");
            return;
        }
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            this.plugin.getLogger().warning("Telemetry endpoint not configured; skipping send.");
            return;
        }
        final String payload = this.buildPayload(additional);
        new BukkitRunnable(){

            @Override
            public void run() {
                try {
                    Telemetry.this.sendPost(payload);
                }
                catch (Exception e) {
                    Telemetry.this.plugin.getLogger().warning("Failed to send telemetry: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously(this.plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPost(String jsonPayload) throws IOException {
        URL url = new URL(ENDPOINT_URL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(8000);
            byte[] out = jsonPayload.getBytes(StandardCharsets.UTF_8);
            conn.setFixedLengthStreamingMode(out.length);
            conn.connect();
            try (OutputStream os = conn.getOutputStream();){
                os.write(out);
            }
            int status = conn.getResponseCode();
            if (status < 200 || status >= 300) {
                String err = Telemetry.readStream(conn.getErrorStream());
                this.plugin.getLogger().warning("Telemetry server returned HTTP " + status + ": " + err);
            } else {
                this.plugin.getLogger().fine("Telemetry sent successfully.");
            }
        }
        finally {
            conn.disconnect();
        }
    }

    private static String toJson(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"").append(Telemetry.escapeJson(e.getKey())).append("\":");
            sb.append(Telemetry.valueToJson(e.getValue()));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String valueToJson(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof Number || val instanceof Boolean) {
            return val.toString();
        }
        if (val instanceof Map) {
            return Telemetry.toJson((Map)val);
        }
        return "\"" + Telemetry.escapeJson(val.toString()) + "\"";
    }

    private static String escapeJson(String s2) {
        return s2.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    private static String readStream(InputStream is) {
        String string;
        if (is == null) {
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder out = new StringBuilder();
            while ((line = br.readLine()) != null) {
                out.append(line);
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "";
            }
        }
        br.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UUID loadOrCreateHwid() {
        File file = new File(this.dataFolder, HWID_FILENAME);
        if (file.exists()) {
            try (BufferedReader br2 = new BufferedReader(new FileReader(file));){
                String line = br2.readLine();
                if (line != null && !line.trim().isEmpty()) {
                    try {
                        UUID uUID = UUID.fromString(line.trim());
                        return uUID;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (IOException br2) {
                // empty catch block
            }
        }
        UUID newId = UUID.randomUUID();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(newId.toString());
            return newId;
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to persist hwid to file: " + e.getMessage());
        }
        return newId;
    }
}

