/*
 * Decompiled with CFR 0.152.
 */
package org.secverse.SecVerseDupeUtils.ItemFrame;

import org.bukkit.entity.EntityType;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.secverse.SecVerseDupeUtils.SecVersDupe;
import org.secverse.SecVerseDupeUtils.helper.CleanShulker;
import org.secverse.SecVerseDupeUtils.helper.EventsKeys;

public class ItemFrameDupe {
    private final SecVersDupe plugin;
    private EventsKeys ek;
    private boolean ITEM_FRAME_Enabled;
    private boolean GLOW_ITEM_FRAME_Enabled;
    private int ITEM_FRAME_Multiplier;
    private int GLOW_ITEM_FRAME_Multiplier;
    private int ITEM_FRAME_Probability;
    private int GLOW_ITEM_FRAME_Probability;

    public ItemFrameDupe(SecVersDupe plugin) {
        this.plugin = plugin;
        this.ek = new EventsKeys(plugin);
        this.reload();
    }

    public void reload() {
        this.ek.reload();
        this.ITEM_FRAME_Enabled = this.plugin.getConfig().getBoolean("FrameDupe.Enabled", false);
        this.ITEM_FRAME_Multiplier = this.plugin.getConfig().getInt("FrameDupe.Multiplier", 1);
        this.ITEM_FRAME_Probability = this.plugin.getConfig().getInt("FrameDupe.Probability-percentage", 0);
        this.GLOW_ITEM_FRAME_Enabled = this.plugin.getConfig().getBoolean("GLOW_FrameDupe.Enabled", false);
        this.GLOW_ITEM_FRAME_Multiplier = this.plugin.getConfig().getInt("GLOW_FrameDupe.Multiplier", 1);
        this.GLOW_ITEM_FRAME_Probability = this.plugin.getConfig().getInt("GLOW_FrameDupe.Probability-percentage", 0);
    }

    private void handleFrameBreak(EntityDamageByEntityEvent event, EntityType expectedType, boolean enabled, int multiplier, int probability) {
        ItemStack item;
        if (!enabled) {
            return;
        }
        if (event.getEntityType() != expectedType) {
            return;
        }
        if (expectedType == EntityType.ITEM_FRAME) {
            item = ((ItemFrame)event.getEntity()).getItem();
        } else if (expectedType == EntityType.GLOW_ITEM_FRAME) {
            item = ((GlowItemFrame)event.getEntity()).getItem();
        } else {
            return;
        }
        if (this.ek.isBlockedItem(item)) {
            return;
        }
        CleanShulker.cleanShulker(item, this.ek);
        int rng = (int)(Math.random() * 100.0);
        if (rng < probability) {
            for (int i = 0; i < multiplier; ++i) {
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), item.clone());
            }
        }
    }

    public class FrameSpecific
    implements Listener {
        @EventHandler
        private void onFrameBreak(EntityDamageByEntityEvent event) {
            ItemFrameDupe.this.handleFrameBreak(event, EntityType.GLOW_ITEM_FRAME, ItemFrameDupe.this.GLOW_ITEM_FRAME_Enabled, ItemFrameDupe.this.GLOW_ITEM_FRAME_Multiplier, ItemFrameDupe.this.GLOW_ITEM_FRAME_Probability);
        }
    }

    public class FrameAll
    implements Listener {
        @EventHandler
        private void onFrameBreak(EntityDamageByEntityEvent event) {
            ItemFrameDupe.this.handleFrameBreak(event, EntityType.ITEM_FRAME, ItemFrameDupe.this.ITEM_FRAME_Enabled, ItemFrameDupe.this.ITEM_FRAME_Multiplier, ItemFrameDupe.this.ITEM_FRAME_Probability);
        }
    }
}

