/*
 * Decompiled with CFR 0.152.
 */
package org.secverse.SecVerseDupeUtils.GrindStone;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.secverse.SecVerseDupeUtils.helper.CleanShulker;
import org.secverse.SecVerseDupeUtils.helper.EventsKeys;

public class GrindStoneDupe
implements Listener {
    private final HashMap<UUID, Long> insertTimes = new HashMap();
    private Plugin plugin;
    private EventsKeys ek;
    private boolean isEnbaled;

    public GrindStoneDupe(Plugin lplugin) {
        this.plugin = lplugin;
        this.ek = new EventsKeys(lplugin);
        this.isEnbaled = this.plugin.getConfig().getBoolean("OtherDupes.GrindStone");
    }

    public void reload() {
        this.isEnbaled = this.plugin.getConfig().getBoolean("OtherDupes.GrindStone");
    }

    @EventHandler
    public void onGrindstoneInsert(InventoryClickEvent event) {
        if (!this.isEnbaled) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.GRINDSTONE) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem != null && currentItem.getType().toString().endsWith("_SHULKER_BOX")) {
            this.insertTimes.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    @EventHandler
    public void onGrindstoneTake(InventoryClickEvent event) {
        if (!this.isEnbaled) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.GRINDSTONE) {
            return;
        }
        if (event.getRawSlot() < 0 || event.getRawSlot() > 2) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem != null && currentItem.getType().toString().endsWith("_SHULKER_BOX")) {
            Long insertTime = this.insertTimes.get(player.getUniqueId());
            if (insertTime == null) {
                return;
            }
            long diff = System.currentTimeMillis() - insertTime;
            if (diff >= 1200L && diff <= 2000L) {
                if (this.ek.isBlockedItem(currentItem)) {
                    CleanShulker.cleanShulker(currentItem, this.ek);
                }
                ItemStack duped = currentItem.clone();
                player.getWorld().dropItemNaturally(player.getLocation(), duped);
            }
            this.insertTimes.remove(player.getUniqueId());
        }
    }
}

