/*
 * Decompiled with CFR 0.152.
 */
package org.secverse.SecVerseDupeUtils.Donkey;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.secverse.SecVerseDupeUtils.helper.CleanShulker;
import org.secverse.SecVerseDupeUtils.helper.EventsKeys;

public class DonkeyShulkerDupe
implements Listener {
    private final Plugin plugin;
    private final EventsKeys ek;
    private final HashMap<UUID, Long> openTimes = new HashMap();
    private Boolean plEnabled;
    private long min;
    private long max;

    public DonkeyShulkerDupe(Plugin plugin) {
        this.plugin = plugin;
        this.ek = new EventsKeys(plugin);
        this.reload();
    }

    public void reload() {
        FileConfiguration config = this.plugin.getConfig();
        this.plEnabled = config.getBoolean("OtherDupes.DonkeyDupe.Enabled");
        this.min = config.getLong("OtherDupes.DonkeyDupe.MinTiming", 100L);
        this.max = config.getLong("OtherDupes.DonkeyDupe.MaxTiming", 800L);
    }

    @EventHandler
    public void onDonkeyOpen(PlayerInteractEntityEvent event) {
        if (!this.plEnabled.booleanValue()) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Donkey)) {
            return;
        }
        Donkey donkey = (Donkey)entity;
        if (!donkey.isCarryingChest()) {
            return;
        }
        this.openTimes.put(donkey.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onDonkeyDeath(EntityDeathEvent event) {
        if (!this.plEnabled.booleanValue()) {
            return;
        }
        if (event.getEntityType() != EntityType.DONKEY) {
            return;
        }
        Donkey donkey = (Donkey)event.getEntity();
        Long openTime = this.openTimes.get(donkey.getUniqueId());
        if (openTime == null) {
            return;
        }
        long diff = System.currentTimeMillis() - openTime;
        if (diff >= this.min && diff <= this.max) {
            AbstractHorseInventory inv = donkey.getInventory();
            for (ItemStack item : inv.getContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                if (this.ek.isBlockedItem(item)) {
                    item.setType(Material.AIR);
                    continue;
                }
                CleanShulker.cleanShulker(item, this.ek);
                donkey.getWorld().dropItemNaturally(donkey.getLocation(), item.clone());
                donkey.getWorld().dropItemNaturally(donkey.getLocation(), item.clone());
            }
        }
        this.openTimes.remove(donkey.getUniqueId());
    }
}

